/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.codexadrian.tempad.Constants;
import me.codexadrian.tempad.TempadClient;
import me.codexadrian.tempad.platform.Services;

public class TempadClientConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    @SerializedName(value="color")
    private int color = -37120;
    @SerializedName(value="colorOptions")
    private int[] colorOptions = new int[]{0xFFFFFF, 16061186, 16218885, 16291078, 16429830, 16502529, 16708356, 15465989, 13368579, 8584705, 5504512, 5504644, 5504689, 5439199, 5439224, 4578046, 3849726, 2790395, 1466107, 400123, 4659964, 6625788, 8133116, 9443838, 11737597, 14031100, 15997180, 15607984, 15480709, 15415392};
    @SerializedName(value="timedoorFancy")
    private boolean isFancyTimedoorRendererEnabled = !TempadClient.isIncompatibleModLoaded();

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int[] getColorOptions() {
        return this.colorOptions;
    }

    public boolean getIfRenderTimedoor() {
        return this.isFancyTimedoorRendererEnabled;
    }

    public static TempadClientConfig loadConfig(Path configFolder) throws IOException {
        Path configPath = configFolder.resolve("tempad_client.json");
        if (!Files.exists(configPath, new LinkOption[0])) {
            TempadClientConfig config = new TempadClientConfig();
            try (FileWriter writer = new FileWriter(configPath.toFile());){
                GSON.toJson((Object)config, (Appendable)writer);
            }
            Constants.LOG.info("Created config file for mod tempad");
            return config;
        }
        return (TempadClientConfig)GSON.fromJson((Reader)new InputStreamReader(Files.newInputStream(configPath, new OpenOption[0])), TempadClientConfig.class);
    }

    public static void saveConfig(TempadClientConfig config) {
        try {
            Path file = Services.PLATFORM.getConfigDir().resolve("tempad_client.json");
            String json = GSON.toJson((Object)config);
            Files.writeString(file, (CharSequence)json, new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

